/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.Items;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.common.IESaveData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VeinGeneratorItem
extends Item {
    private final ResourceLocation resourceLocation;

    public VeinGeneratorItem(Item.Properties properties, ResourceLocation mineralResourceLocation) {
        super(properties);
        this.resourceLocation = mineralResourceLocation;
    }

    public int m_8105_(ItemStack stack) {
        return 20;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        if (player == null || level.m_8055_(pos).m_60795_() || stack.m_41619_()) {
            return InteractionResult.PASS;
        }
        player.m_6672_(context.m_43724_());
        return InteractionResult.SUCCESS;
    }

    private MineralMix getMineralMix(Level level) {
        MineralMix mineralMix = null;
        for (MineralMix mix : MineralMix.RECIPES.getRecipes(level)) {
            if (!mix.m_6423_().equals((Object)this.resourceLocation)) continue;
            mineralMix = mix;
            break;
        }
        return mineralMix;
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity living) {
        if (!(living instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer serverPlayer = (ServerPlayer)living;
        BlockHitResult rtr = VeinGeneratorItem.m_41435_((Level)level, (Player)serverPlayer, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = rtr.m_82425_();
        ColumnPos columnPos = new ColumnPos(pos.m_123341_(), pos.m_123343_());
        MineralVein vein = new MineralVein(columnPos, this.resourceLocation, 15);
        ExcavatorHandler.addVein((ResourceKey)serverPlayer.m_9236_().m_46472_(), (MineralVein)vein);
        IESaveData.markInstanceDirty();
        stack.m_41774_(1);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        if (this.getMineralMix(level) != null) {
            MineralVein vein = new MineralVein(new ColumnPos(1, 1), this.resourceLocation, 15);
            MineralMix mineral = vein.getMineral(level);
            if (mineral != null) {
                String str = Language.m_128107_().m_6834_(mineral.getTranslationKey());
                list.add((Component)Component.m_237113_((String)("\u957f\u6309\u53f3\u952e\u5728\u76ee\u6807\u70b9\u751f\u6210" + str + "\u77ff\u8109")).m_130938_(style -> style.m_178520_(0xFFAAFF)));
            } else {
                list.add((Component)Component.m_237113_((String)"\u957f\u6309\u53f3\u952e\u5728\u76ee\u6807\u70b9\u751f\u6210\u77ff\u8109").m_130938_(style -> style.m_178520_(0xFFAAFF)));
            }
        }
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }
}

